package ws.afterglo.audioPod;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.Iterator;
import java.util.Arrays;

/**
 * @author philippe & northernlad
 *  
 */
public class IScrobbler {
	private Logger logger;
	private static String iniPath;
	private static String logPath = "C:\\_audioscrobbler.log";
	private static String cachePath;
	private int nbSongsCached;
	private int nbSongsSubmit;
	private static int nbLinesCache;
	private ArrayList recentPlayes;
	private int cachePos;
//	Converted allCachedSongs back to TreeList to enable easy sorting.
//  Please see getCachedTracks() for conversion into ArrayList.
	private TreeSet allCachedSongs;
	private UI ui=AudioPod.UI;
	private static String[] iniStr = new String[10];
	
	public IScrobbler() {
		this.logger = Logger.getLogger(this.getClass().getPackage().getName());
		this.recentPlayes = AudioPod.recentplayed;
		allCachedSongs = new TreeSet();
		AudioPod.caching=(findPaths() && parseIni());
	}
	
	private boolean findPaths(){
		boolean flag=true;
		
		//Read C:\\_audioscrobbler.log to find the path of cache and ini files
		File logFile = new File(logPath);
		if (!logFile.isFile()) {
			this.logger.log(Level.INFO, "Error: Logfile (" + logPath + ") not found.");
			flag=false;
		}
		try{
			FileReader fr = new FileReader(logFile);
			BufferedReader br = new BufferedReader(fr);
			iniPath = br.readLine();
			File iniFile=new File(iniPath);
			if (!iniFile.isFile()) {
				this.logger.log(Level.INFO, "Error: iScrobbler.ini (" + iniPath + ") " +
						"not found. The path should be loacated on the first line of "+logPath);
				flag=false;
			}
			cachePath = iniPath.replaceFirst("iScrobbler.ini", ".iScrobbler");
			fr.close();
		}catch(IOException e){
			flag=false;
		}
		return flag;
	}

	private boolean parseIni(){
		boolean flag=true;
		try{
			FileReader fr = new FileReader(iniPath);
			BufferedReader br = new BufferedReader(fr);
			int i=0;

			try{
				while(true){
					iniStr[i] = br.readLine();
					if(iniStr[i].startsWith("cachesize=")){
						cachePos=i;
						//nbSongsCached = Integer.parseInt(iniStr[i].substring(10));
					}
					i++;
				}
			}catch(Exception e){}
			nbLinesCache=i;
			AudioPod.iTunesCount=nbSongsCached;
			if (fr != null)
				fr.close();
		}catch(IOException e){
			this.logger.log(Level.SEVERE, "The file iScrobbler.ini has either not been found or is writeprotected");
			flag=false;
		}
		return flag;
	}
	
	public boolean writeCache() {
		boolean succ=true;
		nbSongsSubmit=AudioPod.toSubmit.size();
		if (nbSongsSubmit == 0)
			return true;
		else {
			try {
				//update cache
				BufferedWriter bw = new BufferedWriter(new FileWriter(cachePath));
				bw.write(createCacheString());
				if (bw != null) bw.close();
				
				//update iScrobller.ini
				bw = new BufferedWriter(new FileWriter(iniPath));
				iniStr[cachePos] = "cachesize=" + (nbSongsSubmit-AudioPod.iPodShortCount);
				for (int i = 0; i < nbLinesCache; i++) {
					bw.write(iniStr[i]);
					bw.newLine();
				}
				if (bw != null) bw.close();

				logger.log(Level.INFO, (nbSongsSubmit-AudioPod.iPodShortCount)+" tracks written to iTunes cache");
				if(!AudioPod.delPlaysEnabled)
					logger.log(Level.INFO, "You must now sync your iPod with your"
										+ " music management software or delete"
										+ " 'Play Counts' from the iTunes folder!");
				//job done; disable the buttons to avoid abuse
				ui.disableCacheB();
				ui.disableSubmitB();
			} catch (Exception e) {
				logger.log(Level.SEVERE, e.toString());
				e.printStackTrace();
				succ=false;
			}
		}
		return succ;
	}

      static char[] specialCharacters = { '&', '<', '>', '\'', '"' };
      static String[] replacementStrings = { "&amp;", "&lt;", "&gt;", "&apos;", "&quot;" };
 
      public String xmlReplace( String text ) {
          StringBuffer buffer = new StringBuffer( text );

          int j = 0;
          int match = 0;
          int k;
          while (j < buffer.length()) {
            k = 0;
            match = 0;
            while (k < specialCharacters.length && match == 0) {
              if( buffer.charAt(j) == specialCharacters[k] ) {
                // logger.log(Level.INFO,"j "+j+" k "+k+" b "+buffer.length());
                buffer.replace( j, j + 1, replacementStrings[k] );
                j += replacementStrings[k].length();
                match = 1;
              } 
              k++;
            }
            if (match == 0)
              j++;
          }
          return buffer.toString();
      }

	public boolean writeAllPlays() {
		boolean succ=true;
		nbSongsSubmit=AudioPod.toSubmit.size();
		if (nbSongsSubmit == 0)
			return true;
		else {
			try {
				//update cache
				cachePath = AudioPod.APPath + "/AllPlaysiPod.xml";
				BufferedWriter bw = new BufferedWriter(new FileWriter(cachePath, true));
				int tracknum = 0;
				Iterator itr = AudioPod.toSubmit.iterator();
		
				while (itr.hasNext()) {
					TrackItem track = (TrackItem) itr.next();
		
					Date date = new Date(track.getLastplayed() * 1000);
					SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					String datestring = format.format(date);
					
					int i = 0;
					iniStr[i++] = "<song timestamp=\"" + datestring + "\">";
					iniStr[i++] = "	<name>" + xmlReplace(new String(track.getTrack().getBytes("UTF-8"), "UTF-8")) + "</name>";


					iniStr[i++] = "	<artist>" + xmlReplace(new String(track.getArtist().getBytes("UTF-8"), "UTF-8")) + "</artist>";
					if (track.getIsCompilation() > 0) {
						iniStr[i++] = "	<compilation>1</compilation>";
					}
					iniStr[i++] = "	<album>" + xmlReplace(new String(track.getAlbum().getBytes("UTF-8"), "UTF-8")) + "</album>";
					iniStr[i++] = "	<track>" + URLEncoder.encode(new Long(track.getTrackNum()).toString(), "UTF-8") + "</track>";
					iniStr[i++] = "	<year>" + URLEncoder.encode(new Long(track.getYear()).toString(), "UTF-8") + "</year>";
					iniStr[i++] = "	<time>" + URLEncoder.encode(new Long(track.getLength()).toString(), "UTF-8") + "</time>";
					iniStr[i++] = "</song>";
		
					tracknum++;
					for (int j = 0; j < track.getPlaycount(); j++) {
						for (int k = 0; k < i; k++) {
							bw.write(iniStr[k]);
							bw.newLine();
						}
					}
				}
				if (bw != null) bw.close();
				
				logger.log(Level.INFO, (nbSongsSubmit-AudioPod.iPodShortCount)+" tracks written to AllPlays XML");
				if(!AudioPod.delPlaysEnabled)
					logger.log(Level.INFO, "You must now sync your iPod with your"
										+ " music management software or delete"
										+ " 'Play Counts' from the iTunes folder!");
				//job done; disable the buttons to avoid abuse
				ui.disableCacheB();
				ui.disableSubmitB();
				ui.disableAllPlaysB();
			} catch (Exception e) {
				logger.log(Level.SEVERE, e.toString());
				e.printStackTrace();
				succ=false;
			}
		}
		return succ;
	}

	public String createCacheString() throws UnsupportedEncodingException,
			NoSuchAlgorithmException, MalformedURLException, IOException {
		String cacheString = "";
		int tracknum = 0;
		Iterator itr = AudioPod.toSubmit.iterator();

		while (itr.hasNext()) {
			TrackItem track = (TrackItem) itr.next();
			if (track.getLength() < 30) {
				continue;
			}

			String artistutf8 = new String(track.getArtist().getBytes("UTF-8"), "UTF-8");
			String trackutf8 = new String(track.getTrack().getBytes("UTF-8"), "UTF-8");
			String albumutf8 = new String(track.getAlbum().getBytes("UTF-8"), "UTF-8");
			String mbidutf8 = new String(track.getMBID().getBytes("UTF-8"), "UTF-8");
			Date date = new Date(track.getLastplayed() * 1000);
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			format.setTimeZone(TimeZone.getTimeZone("GMT:00"));
			String datestring = format.format(date);

			cacheString += "&a[" + tracknum + "]=" + URLEncoder.encode(artistutf8, "UTF-8");
			cacheString += "&b[" + tracknum + "]=" + URLEncoder.encode(albumutf8, "UTF-8");
			cacheString += "&t[" + tracknum + "]=" + URLEncoder.encode(trackutf8, "UTF-8");
			cacheString += "&i[" + tracknum + "]=" + URLEncoder.encode(datestring, "UTF-8");
			cacheString += "&l[" + tracknum + "]=" + URLEncoder.encode(new Long(track.getLength()).toString(), "UTF-8");
			cacheString += "&m[" + tracknum + "]=" + URLEncoder.encode(mbidutf8, "UTF-8");

			tracknum++;
		}
		return cacheString;
	}

	public int addIpodSongs() {
		int tracknum = nbSongsCached;

		for (int i = 0; i < recentPlayes.size(); i++) {
			TrackItem track = (TrackItem) AudioPod.recentplayed.get(i);
			allCachedSongs.add(track);
			tracknum++;
		}
		return tracknum;
	}

	public int parseCacheFile() throws UnsupportedEncodingException {
		String cache = "";
		try {
			BufferedReader in = new BufferedReader(new FileReader(cachePath));
			cache = in.readLine();
			in.close();
		} catch (Exception e) {
			return 0;
		}
		
		int head = 0, tail = 0;
		int i=0;
		while(true){
			head = cache.indexOf("&", tail);
			head = (cache.indexOf("]=", head)) + 2;
			tail = cache.indexOf("&", head);
			String artist = URLDecoder.decode(new String(cache.substring(head, tail).getBytes("UTF-8"), "UTF-8"), "UTF-8");
			
			head = tail;
			head = (cache.indexOf("]=", head)) + 2;
			tail = cache.indexOf("&", head);
			String album = URLDecoder.decode(new String(cache.substring(head, tail).getBytes("UTF-8"), "UTF-8"), "UTF-8");
		
			head = tail;
			head = (cache.indexOf("]=", head)) + 2;
			tail = cache.indexOf("&", head);
			String title = URLDecoder.decode(new String(cache.substring(head, tail).getBytes("UTF-8"), "UTF-8"), "UTF-8");
				
			head = tail;
			head = (cache.indexOf("]=", head)) + 2;
			tail = cache.indexOf("&", head);
				
	        String date = URLDecoder.decode(new String(cache.substring(head, tail).getBytes("UTF-8"), "UTF-8"), "UTF-8");    
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			sdf.setTimeZone(TimeZone.getTimeZone("GMT:00"));
			long time = 0;
			try {
				time = sdf.parse(date).getTime()/1000;
			} catch (Exception e) {
				logger.log(Level.SEVERE, "Wrong date format to convert to timestamp");
			}
		
			head = tail;
			head = (cache.indexOf("]=", head)) + 2;
			tail = cache.indexOf("&", head);
			long length = Long.parseLong(cache.substring(head, tail));
		
			head = tail;
			head = (cache.indexOf("]=", head)) + 2;
			tail = cache.indexOf("&", head);
			String mbid = "";
			try {
				mbid = URLDecoder.decode(new String(cache.substring(head, tail).getBytes("UTF-8"), "UTF-8"), "UTF-8");
			} catch (RuntimeException e) {
				;
			}

			TrackItem track = new TrackItem();
		
			track.setArtist(artist);
			track.setTrack(title);
			track.setAlbum(album);
			track.setLength(length);
			track.setLastplayed(time);
			track.setMBID(mbid);
			track.setSource("iTunes");
			allCachedSongs.add(track);
			if(tail==-1)
				break;
			head = i;
			i++;
		}
		//nbSongsCached=i;
		AudioPod.iTunesCount=i+1;
		return head;
	}

	public static void clearCache(){
		
		//delete cache file if it exists
		File cache=new File(cachePath);
		if(cache.isFile())
			cache.delete();
		
		//update iScrobller.ini
		try{
			BufferedWriter bw = new BufferedWriter(new FileWriter(iniPath));
			for (int i = 0; i < nbLinesCache; i++) {
				if(iniStr[i].startsWith("cachesize="))
					bw.write("cachesize=0");
				else
					bw.write(iniStr[i]);
				bw.newLine();
			}
			if (bw != null) bw.close();
		}catch(IOException e){
			;
		}
	}
	
	public ArrayList getCachedTracks()
	{
		/* since allCachedSongs is a TreeSet and we need to return an 
		 * ArrayList a little typecasting needs to be done.
		 */
		return new ArrayList(Arrays.asList(allCachedSongs.toArray()));	
	}
}
